package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.Value;

import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.api.services.hotels.calendar_prices.CalendarDayPrice;

@Data
@ApiModel(value = "Календарь цен - ответ")
public class GetCalendarPricesRspV1 {
    @Value
    public static class IPriceInfo {
        public IPriceInfo(CalendarDayPrice p){
            this.date = p.getDate().toString();
            if (p.getCheckoutDate() != null) {
                this.checkoutDate = p.getCheckoutDate().toString();
            }else{
                this.checkoutDate = null;
            }
            this.price = p.getPrice();
        }
        String date;
        String checkoutDate;
        Price price;
    }

    private List<IPriceInfo> prices;
    private String context;
    private boolean isFinished;
    private Integer nextPollingRequestDelayMs;
}
