package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;


@ApiModel(value = "Запрос данных статической страницы города")
@Data
@Valid
public class GetCityStaticPageReqV1 {
    @ParamName("regionSlug")
    @ApiParam(name = "", value = "Slug региона")
    @NotNull
    private String regionSlug;

    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("filterSlug")
    @ApiParam(name = "filterSlug", value = "Slug фильтра")
    private String filterSlug = null;
}
