package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import ru.yandex.travel.api.models.Region;
import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.crosslinks.CrosslinksHotelsBlockData;
import ru.yandex.travel.api.models.hotels.HotelWithMinPrice;
import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.api.models.hotels.SearchFilterAndTextParams;
import ru.yandex.travel.api.models.hotels.SortId;
import ru.yandex.travel.api.models.hotels.breadcrumbs.Breadcrumbs;
import ru.yandex.travel.api.models.hotels.seo.GeoRegionSchemaOrgInfo;
import ru.yandex.travel.api.models.hotels.seo.SeoInfo;

@ApiModel(value = "Ответ данными для рендеринга статической страницы")
@Data
public class GetCityStaticPageRspV1 {

    public interface GeoRegionBlock {
        public abstract GeoRegionBlockType getType();
    }

    public interface DataType {
    }

    public interface EmptyDataType extends DataType {
    }

    public interface ChildType extends GeoRegionBlock {
    }

    /**
     * Doctor Who pun intended
     */
    public interface EmptyChild extends ChildType {
    }

    @Getter
    @AllArgsConstructor
    public enum GeoRegionBlockType {
        SEARCH_FORM_BLOCK("ISearchFormBlock"),
        BREADCRUMBS_BLOCK("IBreadcrumbsBlock"),
        HOTELS_BLOCK("IHotelsBlock"),
        HOTELS_FILTERS_BLOCK("IHotelsFiltersBlock"),
        CROSS_SALE_HOTELS_BLOCK("ICrossSaleHotelsBlock"),
        REGION_LINK_SET_BLOCK("IRegionLinkSetBlock"),
        REGION_LINK_SUB_SET_BLOCK("IRegionLinkSubSetBlock"),
        SECTION_TEXT_BLOCK("ISectionTextBlock"),
        SUB_SECTION_TEXT_BLOCK("ISubSectionTextBlock"),
        TEXT_BLOCK("ITextBlock"),
        SPOILER_BLOCK("ISpoilerBlock"),
        PRICE_TEXT_BLOCK("IPriceTextBlock"),
        PLAIN_TEXT_BLOCK("IPlainTextBlock"),
        EXTERNAL_LINK_BLOCK("IExternalLinkBlock"),
        HOTEL_LINK_BLOCK("IHotelLinkBlock"),
        REGION_LINK_BLOCK("IRegionLinkBlock"),
        SEARCH_HOTELS_LINK_BLOCK("ISearchHotelsLinkBlock"),
        GEO_LINK_GROUP_BLOCK("IGeoLinkGroupBlock"),
        ;

        @JsonValue
        private final String typeName;
    }

    @Data
    public static abstract class DataBearer<DType extends DataType, CType extends ChildType> {
        private DType data;
        private List<CType> children;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class SearchFormBlock extends DataBearer<SearchFormBlockData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.SEARCH_FORM_BLOCK;
        }
    }

    @Data
    public static class SearchFormBlockData implements DataType {
        private String imageUrl;
        private String title;
        private SearchFormParams searchFormParams;
        private SearchFilterAndTextParams filterParams;
    }

    @Data
    public static class SearchFormParams {
        private String regionSlug;
        private Boolean isCalendarOpen;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class BreadcrumbsBlock extends DataBearer<BreadcrumbsData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.BREADCRUMBS_BLOCK;
        }
    }

    @Data
    public static class BreadcrumbsData implements DataType {
        private Breadcrumbs breadcrumbs;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class HotelsBlock extends DataBearer<HotelsBlockData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.HOTELS_BLOCK;
        }
    }

    @Data
    public static class HotelsBlockData implements DataType {
        private String title;
        private List<HotelWithMinPrice> hotels;
        private String searchButtonText;
        private SearchPageIdentifyParams searchParams;
        private Region region;
    }

    @Data
    public static class SearchPageIdentifyParams {
        private Integer geoId;
        private SortId selectedSortId;
        private SearchFilterAndTextParams filterParams;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class HotelsFilterBlock extends DataBearer<HotelsFilterBlockData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.HOTELS_FILTERS_BLOCK;
        }
    }

    @Data
    public static class HotelsFilterBlockData implements DataType {
        private SearchHotelsRspV1.FilterInfo filterInfo;
        private SearchPageIdentifyParams searchParams;
    }

    @Data
    public static class CrossSaleHotelsBlock implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.CROSS_SALE_HOTELS_BLOCK;
        }

        private CrosslinksHotelsBlockData data;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class RegionLinkSetBlock extends DataBearer<RegionLinkSetBlockData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.REGION_LINK_SET_BLOCK;
        }
    }

    @Data
    public static class RegionLinkSetBlockData implements DataType {
        private String title;
        private List<RegionLinkSubSetBlock> subsets;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class RegionLinkSubSetBlock extends DataBearer<RegionLinkSubSetBlockData, EmptyChild> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.REGION_LINK_SUB_SET_BLOCK;
        }
    }

    @Data
    public static class RegionLinkSubSetBlockData implements DataType {
        private String title;
        private List<RegionLinkBlock> links;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class SectionTextBlock extends DataBearer<SectionTextBlockData, SectionTextChildBlock> implements GeoRegionBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.SECTION_TEXT_BLOCK;
        }
    }

    @Data
    public static class SectionTextBlockData implements DataType {
        private String title;
    }

    public interface SectionTextChildBlock extends ChildType {
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class SubSectionTextBlock extends DataBearer<SubSectionTextBlockData, SubSectionTextBlockChild> implements SectionTextChildBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.SUB_SECTION_TEXT_BLOCK;
        }
    }

    @Data
    public static class SubSectionTextBlockData implements DataType {
        private String title;
    }

    public interface SubSectionTextBlockChild extends ChildType {
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class SpoilerBlock extends DataBearer<SpoilerBlockData, EmptyChild> implements SectionTextChildBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.SPOILER_BLOCK;
        }
    }

    @Data
    public static class SpoilerBlockData implements DataType {
        private String title;
        private Paragraph description;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Paragraph extends DataBearer<EmptyDataType, ParagraphBlock> implements SubSectionTextBlockChild, SectionTextChildBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.TEXT_BLOCK;
        }
    }

    public interface ParagraphBlock extends ChildType {
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class ExternalLinkBlock extends DataBearer<ExternalLinkBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.EXTERNAL_LINK_BLOCK;
        }
    }

    @Data
    public static class ExternalLinkBlockData implements DataType {
        private String text;
        private String url;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class HotelLinkBlock extends DataBearer<HotelLinkBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.HOTEL_LINK_BLOCK;
        }
    }

    @Data
    public static class HotelLinkBlockData implements DataType {
        @Data
        public static class UrlParams {
            private String hotelSlug;
        }

        private String text;
        private UrlParams urlParams;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class RegionLinkBlock extends DataBearer<RegionLinkBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.REGION_LINK_BLOCK;
        }
    }

    @Data
    public static class RegionLinkBlockData implements DataType {
        @Data
        public static class UrlParams {
            private String regionSlug;
            private String filterSlug;
        }

        private String text;
        private UrlParams urlParams;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class SearchHotelsLinkBlock extends DataBearer<SearchHotelsLinkBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.SEARCH_HOTELS_LINK_BLOCK;
        }
    }

    @Data
    public static class SearchHotelsLinkBlockData implements DataType {
        private String text;
        private SearchPageIdentifyParams urlParams;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class PriceTextBlock extends DataBearer<PriceTextBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.PRICE_TEXT_BLOCK;
        }
    }

    @Data
    public static class PriceTextBlockData implements DataType {
        private Price price;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class PlainTextBlock extends DataBearer<PlainTextBlockData, EmptyChild> implements ParagraphBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.PLAIN_TEXT_BLOCK;
        }
    }

    @Data
    public static class PlainTextBlockData implements DataType {
        @AllArgsConstructor
        public enum Style {
            BOLD("bold"),
            ITALIC("italic"),
            ;
            @JsonValue
            private final String styleName;
        }

        private String text;
        private List<Style> styles;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class GeoLinkGroupBlock extends DataBearer<GeoLinkGroupBlockData, EmptyChild> implements SectionTextChildBlock {
        @Override
        public GeoRegionBlockType getType() {
            return GeoRegionBlockType.GEO_LINK_GROUP_BLOCK;
        }
    }

    @Data
    public static class GeoLinkGroupBlockData implements DataType {
        private RegionLinkBlock mainLink;
        private RegionLinkBlock additionalLink;
    }

    @ApiModelProperty(value = "Seo info")
    private SeoInfo<GeoRegionSchemaOrgInfo> seoInfo;
    private List<GeoRegionBlock> blocks;
    private ExtraVisitAndUserParams extraVisitAndUserParams;
}
