package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Получение отелей для кросс-сейла на транспортных вертикалях - запрос")
public class GetCrossSaleHotelsReqV1 extends RequestAttributionProviderImpl {
    // Own fields
    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("settlement_id")
    @ApiParam(name = "settlement_id", value = "Регион поиска (авиа settlement id в формате 'c{raspId}')")
    @NotEmpty
    @NotNull
    private String settlementId;

    @ParamName("total_hotel_limit")
    @ApiParam(name = "total_hotel_limit", value = "Сколько отелей нужно")
    @NotNull
    @Min(0)
    @Max(1000)
    private Integer totalHotelLimit;
}
