package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.hotels.common.Ages;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Получение отелей для кросс-сейла на транспортных вертикалях с поллингом - запрос")
public class GetCrossSaleHotelsReqV3 extends RequestAttributionProviderImpl {
    // Own fields
    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("point_key")
    @ApiParam(name = "point_key", value = "Регион поиска (поддержаны settlement ('c{raspId}') и station ('s{raspId}')")
    @NotEmpty
    @NotNull
    private String pointKey;

    @ParamName("total_hotel_limit")
    @ApiParam(name = "total_hotel_limit", value = "Сколько отелей нужно")
    @NotNull
    @Min(0)
    @Max(1000)
    private Integer totalHotelLimit;

    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    @NotNull
    private Integer adults = 2;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;
}
