package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.crosslinks.CrosslinksHotelsBlockData;

@Data
@NoArgsConstructor
@ApiModel(value = "Получение отелей для кросс-сейла на транспортных вертикалях - ответ")
public class GetCrossSaleHotelsRspV1 extends CrosslinksHotelsBlockData {
    public GetCrossSaleHotelsRspV1(CrosslinksHotelsBlockData hotelsBlockData) {
        hasData = hotelsBlockData.isHasData();
        region = hotelsBlockData.getRegion();
        minPriceInRegion = hotelsBlockData.getMinPriceInRegion();
        bboxAsString = hotelsBlockData.getBboxAsString();
        bboxAsStruct = hotelsBlockData.getBboxAsStruct();
        hotels = hotelsBlockData.getHotels();
        totalHotelCount = hotelsBlockData.getTotalHotelCount();
        regionImageUrl = hotelsBlockData.getRegionImageUrl();
    }
}
