package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.Region;
import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.api.models.hotels.HotelWithOffers;
import ru.yandex.travel.api.models.hotels.OfferSearchProgress;
import ru.yandex.travel.api.models.hotels.Price;

@Data
@NoArgsConstructor
@ApiModel(value = "Получение отелей для кросс-сейла на транспортных вертикалях с поллингом - ответ")
public class GetCrossSaleHotelsRspV2 {
    private boolean hasData;
    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;

    private Region region;

    private Price minPriceInRegion;

    private BoundingBox bboxAsString;
    private List<Coordinates> bboxAsStruct;

    private List<HotelWithOffers> hotels;

    private int totalHotelCount;

    private String regionImageUrl;
}
