package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.Map;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.OfferSearchParams;
import ru.yandex.travel.api.models.hotels.OfferSearchProgress;
import ru.yandex.travel.api.models.hotels.ShortHotelOffersInfo;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@ApiModel(value = "Получение избранных отелей - ответ")
public class GetFavoriteHotelsOffersRspV1 {
    private OfferSearchParams offerSearchParams;
    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;

    // Контекст поллинга
    private String context;

    Map<Permalink, ShortHotelOffersInfo> offers;

    private ExtraVisitAndUserParams extraVisitAndUserParams;

    @Data
    @NoArgsConstructor
    public static class FavoriteCategory {
        // Уникальный идентификатор
        private String id;
        // Название.
        private String name;
    }
}
