package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.HotelWithOffers;
import ru.yandex.travel.api.models.hotels.OfferSearchParams;
import ru.yandex.travel.api.models.hotels.OfferSearchProgress;

@Data
@NoArgsConstructor
@ApiModel(value = "Получение избранных отелей - ответ")
public class GetFavoriteHotelsRspV1 {
    private OfferSearchParams offerSearchParams;
    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;

    // Контекст поллинга
    private String context;

    // Id выбранной категории (может отличаться от переданного в запросе)
    private String selectedCategoryId;

    // Все доступные категории. Обязательно содержит категорию с id == category
    private List<FavoriteCategory> categories;

    private List<HotelWithOffers> hotels;
    private int totalHotelCount;
    private ExtraVisitAndUserParams extraVisitAndUserParams;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FavoriteCategory {
        // Уникальный идентификатор
        private String id;
        // Название.
        private String name;
        // Количество отелей в категории
        private long hotelCount;
    }
}
