package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.Set;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.api.models.hotels.interfaces.ImageParamsProvider;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос фотографий отеля")
public class GetHotelImagesReqV1 implements ImageParamsProvider, HotelIdentifierProvider {
    // ImageParamsProvider
    @ParamName("image_limit")
    @ApiParam(name = "image_limit", value = "Image Limit")
    private Integer imageLimit = null;

    @ParamName("image_offset")
    @ApiParam(name = "image_offset", value = "Image Offset")
    private int imageOffset = 0;

    @ParamName("image_sizes")
    @ApiParam(name = "image_sizes", value = "Image sizes")
    private Set<String> imageSizes = null;

    @ParamName("only_top_images")
    @ApiParam(name = "only_top_images", value = "Include only top images")
    @NotNull
    private boolean onlyTopImages = false;// not included in spec

    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;

    // Own fields
    @ParamName("parent_request_id")
    @ApiParam(name = "parent_request_id", value = "Parent ReqId")
    private String parentRequestId;
}
