package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.ETextReviewRanking;
import ru.yandex.travel.api.models.hotels.interfaces.DebugOfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.api.models.hotels.interfaces.HotelTestableUgcProvider;
import ru.yandex.travel.api.models.hotels.interfaces.ImageParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.hotels.common.Ages;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Запрос информации об отеле")
public class GetHotelInfoReqV1
        extends RequestAttributionProviderImpl
        implements OfferSearchParamsProvider, ImageParamsProvider, DebugOfferSearchParamsProvider,
        HotelIdentifierProvider, HotelTestableUgcProvider {

    // OfferSearchParamsProvider
    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    private Integer adults;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;

    // DebugOfferSearchParamsProvider
    @ParamName("debug_portal_host")
    @ApiParam(name = "debug_portal_host")
    private String debugPortalHost;

    @ParamName("debug_use_prod_offers")
    @ApiParam(name = "debug_use_prod_offers")
    private boolean debugUseProdOffers = false;

    // ImageParamsProvider
    @ParamName("image_limit")
    @ApiParam(name = "image_limit", value = "Image Limit")
    private Integer imageLimit = null;

    @ParamName("image_offset")
    @ApiParam(name = "image_offset", value = "Image Offset")
    private int imageOffset = 0;

    @ParamName("image_sizes")
    @ApiParam(name = "image_sizes", value = "Image sizes")
    private Set<String> imageSizes = null;

    @ParamName("only_top_images")
    @ApiParam(name = "only_top_images", value = "Include only top images")
    @NotNull
    private boolean onlyTopImages = true;// not included in spec

    // For BoY page
    @ParamName("token")
    @ApiParam(name = "token", value = "Токен")
    private String token;

    @ParamName("label")
    @ApiParam(name = "label", value = "Лабел")
    private String label;

    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;

    // HotelTestableUgcProvider
    @ParamName("enabled_test_ugc")
    @ApiParam(name = "enabled_test_ugc", value = "Enable testing for UGC")
    public boolean enabledTestUgc = false;

    // Own fields


    @ParamName("searchPagePollingId")
    @ApiParam(name = "searchPagePollingId", value = "id поиска со страницы поиска отелей")
    private String searchPagePollingId;

    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("text_review_limit")
    @ApiParam(name = "text_review_limit", value = "Лимит на отзывы")
    @NotNull
    @Max(Constraints.TEXT_REVIEW_LIMIT_MAX)
    private int textReviewLimit = 10;

    @ParamName("text_review_offset")
    @ApiParam(name = "text_review_offset", value = "Text review offset")
    @NotNull
    private int textReviewOffset = 0;

    @ParamName("text_review_ranking")
    @ApiParam(name = "text_review_ranking", value = "Text review ranking")
    @NotNull
    private ETextReviewRanking textReviewRanking = ETextReviewRanking.byRelevanceOrg;

    @ParamName("similar_hotel_limit")
    @ApiParam(name = "similar_hotel_limit", value = "Лимит на похожие отели")
    @NotNull
    private int similarHotelLimit = 10;

    @ParamName("key_phrase_limit")
    @ApiParam(name = "key_phrase_limit", value = "Лимит на ключевые фразы")
    @NotNull
    private int keyPhraseLimit = 10;

    @ParamName("key_phrase_filter")
    @ApiParam(name = "key_phrase_filter", value = "Key Phrase to filter")
    private String keyPhraseFilter;

    @ParamName("seed")
    @ApiParam(name = "seed", value = "Маркер запроса, влияющий на отображение страницы")
    private String seed;

    @ParamName("enable_permarooms")
    @ApiParam(name = "enable_permarooms", value = "Внутренний параметр для дебага: флажок для выключения пермарумов")
    private boolean enablePermarooms = true;

    @ParamName("enable_deduplication")
    @ApiParam(name = "enable_deduplication", value = "Внутренний параметр для дебага: флажок для выключения дедупликации офферов")
    private boolean enableDeduplication = true;

    @ParamName("use_default_search_params")
    @ApiParam(name = "use_default_search_params", value = "Маркер, помечающий, " +
            "что можно использовать значения по умолчанию для дат заезда выезда и гостей." +
            "Если переданы поля отвечающие за даты заезда, то они будут в приоритете")
    private boolean useDefaultSearchParams = false;

    @Override
    public boolean hasSearchParams() {
        return getCheckinDate() != null || getCheckoutDate() != null || getAdults() != null;
    }
}
