package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.Hotel;
import ru.yandex.travel.api.models.hotels.HotelOffersInfo;
import ru.yandex.travel.api.models.hotels.HotelRatings;
import ru.yandex.travel.api.models.hotels.HotelReviewsInfo;
import ru.yandex.travel.api.models.hotels.SimilarHotelsInfo;
import ru.yandex.travel.api.models.hotels.breadcrumbs.Breadcrumbs;
import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.seo.HotelSchemaOrgInfo;
import ru.yandex.travel.api.models.hotels.seo.SeoInfo;

@Data
@NoArgsConstructor
@ApiModel(value = "Информация про отель - ответ")
public class GetHotelInfoRspV1 {
    private OfferSearchParamsProvider searchParams;
    private String parentRequestId;
    private Hotel hotel;
    private Description hotelDescription;
    private Breadcrumbs breadcrumbs;
    private HotelOffersInfo offersInfo;
    private SimilarHotelsInfo similarHotelsInfo;
    private HotelReviewsInfo reviewsInfo;
    private HotelRatings ratingsInfo;
    private SeoInfo<HotelSchemaOrgInfo> seoInfo;
    private Breadcrumbs seoBreadcrumbs;
    private ExtraVisitAndUserParams extraVisitAndUserParams;

    @Data
    @NoArgsConstructor
    public static class Description {
        private String text;
    }
}
