package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.ETextReviewRanking;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.api.models.hotels.interfaces.HotelTestableUgcProvider;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос отзывов об отеле")
public class GetHotelReviewsReqV1 implements HotelIdentifierProvider, HotelTestableUgcProvider {
    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;

    // HotelTestableUgcProvider
    @ParamName("enabled_test_ugc")
    @ApiParam(name = "enabled_test_ugc", value = "Enable testing for UGC")
    public boolean enabledTestUgc;

    // Own fields
    @ParamName("parent_request_id")
    @ApiParam(name = "parent_request_id", value = "Parent ReqId")
    private String parentRequestId;

    @ParamName("text_review_limit")
    @ApiParam(name = "text_review_limit", value = "Text review limit")
    @NotNull
    @Max(Constraints.TEXT_REVIEW_LIMIT_MAX)
    private int textReviewLimit = 10;

    @ParamName("text_review_offset")
    @ApiParam(name = "text_review_offset", value = "Text review offset")
    @NotNull
    private int textReviewOffset = 0;

    @ParamName("key_phrase_limit")
    @ApiParam(name = "key_phrase_limit", value = "Key Phrase limit")
    @NotNull
    private int keyPhraseLimit = 10;

    @ParamName("key_phrase_filter")
    @ApiParam(name = "key_phrase_filter", value = "Key Phrase to filter")
    private String keyPhraseFilter;

    @ParamName("text_review_ranking")
    @ApiParam(name = "text_review_ranking", value = "Text review ranking")
    @NotNull
    private ETextReviewRanking textReviewRanking = ETextReviewRanking.byRelevanceOrg;
}
