package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "Отель", description = "Информация для отображения на карточке отеля")
public class GetLegacyHotelRspV1 {
    public enum PriceType {
        MINIMUM,
        MEDIAN
    }

    public enum Currency {
        RUB,
        USD,
        EUR
    }

    @Data
    @ApiModel("Цена")
    public static class Price {
        @ApiModelProperty("Сумма")
        private Double amount;
        @ApiModelProperty("Тип цены: минимальная или средняя")
        private PriceType type;
        @ApiModelProperty("Валюта")
        private Currency currency;
    }

    @ApiModelProperty("legacy travel-id отеля")
    private long id;
    @ApiModelProperty("Название отеля")
    private String name;
    @ApiModelProperty("Адрес отеля (город, улица, дом")
    private String address;
    @ApiModelProperty("Страна отеля")
    private String country;
    @ApiModelProperty("Заглавная картинка отеля")
    private String image;
    @ApiModelProperty(value = "Пермалинк отеля", allowEmptyValue = true)
    private Permalink permalink;
    /** Главный slug отеля. Может отсутствовать. */
    private String hotelSlug;
    @ApiModelProperty(value = "Средняя цена номера за ночь", allowEmptyValue = true)
    private Price price;
    @ApiModelProperty(value = "Количество звезд отеля", allowEmptyValue = true)
    private Integer stars;
    @ApiModelProperty(value = "Рейтинг отеля", allowEmptyValue = true)
    private Double rating;
    @ApiModelProperty("Адрес для поиска отеля")
    private String searchUrl;
    @ApiModelProperty("Основные удобства отеля")
    private List<String> features;
}
