package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.interfaces.DebugOfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.ImageParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.hotels.common.Ages;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Получение избранных отелей")
public class GetSharedFavoriteHotelsReqV1
        extends RequestAttributionProviderImpl
        implements OfferSearchParamsProvider, DebugOfferSearchParamsProvider, ImageParamsProvider {

    // OfferSearchParamsProvider
    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    @NotNull
    private Integer adults = 2;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;

    // DebugOfferSearchParamsProvider
    @ParamName("debug_portal_host")
    @ApiParam(name = "debug_portal_host")
    private String debugPortalHost;

    @ParamName("debug_use_prod_offers")
    @ApiParam(name = "debug_use_prod_offers")
    private boolean debugUseProdOffers = false;

    // ImageParamsProvider
    @ParamName("image_limit")
    @ApiParam(name = "image_limit", value = "Image Limit")
    private Integer imageLimit = null;

    @ParamName("image_offset")
    @ApiParam(name = "image_offset", value = "Image Offset")
    private int imageOffset = 0; // not included in spec

    @ParamName("image_sizes")
    @ApiParam(name = "image_sizes", value = "Image sizes")
    private Set<String> imageSizes = null;

    @ParamName("only_top_images")
    @ApiParam(name = "only_top_images", value = "Include only top images")
    @NotNull
    private boolean onlyTopImages = true; // not included in spec

    // Own fields
    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("token")
    @ApiParam(name = "token", value = "Токен избранного")
    @NotNull
    @NotEmpty
    private String token;

    @ParamName("offset")
    @ApiParam(name = "offset", value = "Сколько отелей пропустить")
    @NotNull
    private Integer offset;

    @ParamName("limit")
    @ApiParam(name = "limit", value = "Сколько отелей вернуть (максимум)")
    @NotNull
    @Max(Constraints.TOTAL_HOTEL_LIMIT_MAX)
    private Integer limit;
}
