package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.HotelWithOffers;
import ru.yandex.travel.api.models.hotels.OfferSearchParams;
import ru.yandex.travel.api.models.hotels.OfferSearchProgress;

@Data
@NoArgsConstructor
@ApiModel(value = "Получение избранных отелей - ответ")
public class GetSharedFavoriteHotelsRspV1 {
    private OfferSearchParams offerSearchParams;
    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;

    // Контекст поллинга
    private String context;

    private List<HotelWithOffers> hotels;
    private int totalHotelCount;

    private ExtraVisitAndUserParams extraVisitAndUserParams;

    @Data
    @NoArgsConstructor
    public static class FavoriteOwner {
        // Имя/ник
        private String name;
    }
}
