package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;


@ApiModel(value = "Запрос для логирования саджеста, выбранного пользователем")
@Data
public class LogSuggestReqV1 {

    @ParamName("selectedId")
    @ApiParam(name = "selectedId", value = "Идентификатор саджеста, выбранный пользователем")
    private String selectedId;

    @ParamName("sessionId")
    @ApiParam(name = "sessionId", value = "Идентификатор сессии для логов")
    private String sessionId;

    @ParamName("requestIndex")
    @ApiParam(name = "requestIndex", value = "Порядковый номер запроса для логов")
    private Integer requestIndex;

    @ParamName("isManualClick")
    @ApiParam(name = "isManualClick", value = "Флаг, обозначающий, что саггест выбран мануально, те клик или ентер")
    private Boolean isManualClick;

    @ParamName("isTrustedUser")
    @ApiParam(name = "isTrustedUser", value = "Флаг, обозначающий, что саггест выбран человеком, а не роботом")
    private Boolean isTrustedUser;
}
