package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.Size;

import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.interfaces.RequestAttributionProvider;

@Data
public abstract class RequestAttributionProviderImpl implements RequestAttributionProvider {
    @ParamName("utm_source")
    @ApiParam(name = "utm_source")
    @Size(max = Constraints.UTM_SOURCE_SIZE_MAX)
    private String utmSource;

    @ParamName("utm_medium")
    @ApiParam(name = "utm_medium")
    @Size(max = Constraints.UTM_MEDIUM_SIZE_MAX)
    private String utmMedium;

    @ParamName("utm_campaign")
    @ApiParam(name = "utm_campaign")
    @Size(max = Constraints.UTM_CAMPAIGN_SIZE_MAX)
    private String utmCampaign;

    @ParamName("utm_term")
    @ApiParam(name = "utm_term")
    @Size(max = Constraints.UTM_TERM_SIZE_MAX)
    private String utmTerm;

    @ParamName("utm_content")
    @ApiParam(name = "utm_content")
    @Size(max = Constraints.UTM_CONTENT_SIZE_MAX)
    private String utmContent;

    @ParamName("serp_req_id")
    @ApiParam(name = "serp_req_id")
    @Size(max = Constraints.SERP_REQ_ID_SIZE_MAX)
    private String serpReqId;

    @ParamName("gclid")
    @ApiParam(name = "gclid")
    @Size(max = Constraints.GCLID_SIZE_MAX)
    private String gclid;

    @ParamName("user_region")
    @ApiParam(name = "user_region")
    private Integer userRegion;

    @ParamName("ytp_referer")
    @ApiParam(name = "ytp_referer")
    @Size(max = Constraints.YTP_REFERER_SIZE_MAX)
    private String ytpReferer;

    @ParamName("yclid")
    @ApiParam(name = "yclid")
    @Size(max = Constraints.YCLID_SIZE_MAX)
    private String yclid;

    @ParamName("fbclid")
    @ApiParam(name = "fbclid")
    @Size(max = Constraints.FBCLID_SIZE_MAX)
    private String fbclid;

    @ParamName("metrika_client_id")
    @ApiParam(name = "metrika_client_id")
    @Size(max = Constraints.METRIKACLIENTID_SIZE_MAX)
    private String metrikaClientId;

    @ParamName("metrika_user_id")
    @ApiParam(name = "metrika_user_id")
    @Size(max = Constraints.METRIKAUSERID_SIZE_MAX)
    private String metrikaUserId;

    @ParamName("clid")
    @ApiParam(name = "clid")
    @Size(max = Constraints.AFFILIATECLID_SIZE_MAX)
    private String clid;

    @ParamName("affiliate_clid")
    @ApiParam(name = "affiliate_clid")
    @Size(max = Constraints.AFFILIATECLID_SIZE_MAX)
    private String affiliateClid;

    @ParamName("admitad_uid")
    @ApiParam(name = "admitad_uid")
    @Size(max = Constraints.ADMITADUID_SIZE_MAX)
    private String admitadUid;

    @ParamName("travelpayouts_uid")
    @ApiParam(name = "travelpayouts_uid")
    @Size(max = Constraints.TRAVELPAYOUTSUID_SIZE_MAX)
    private String travelpayoutsUid;

    @ParamName("vid")
    @ApiParam(name = "vid")
    @Size(max = Constraints.AFFILIATEVID_SIZE_MAX)
    private String vid;

    @ParamName("affliate_vid")
    @ApiParam(name = "affliate_vid")
    @Size(max = Constraints.AFFILIATEVID_SIZE_MAX)
    private String affiliateVid;

    @ParamName("referral_partner_request_id")
    @ApiParam(name = "referral_partner_request_id", value = "id перехода от партнера на Путешествия или WL")
    @Size(max = Constraints.REFERRAL_PARTNER_REQUEST_ID_LIMIT_MAX)
    private String referralPartnerRequestId;
}
