package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.api.models.hotels.GeoLocationStatus;
import ru.yandex.travel.api.models.hotels.interfaces.DebugOfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.ImageParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.SearchFilterParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.SearchSortParamsProvider;
import ru.yandex.travel.hotels.common.Ages;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Поиск отелей")
public class SearchHotelsReqV1
        extends RequestAttributionProviderImpl
        implements OfferSearchParamsProvider, DebugOfferSearchParamsProvider, SearchFilterParamsProvider,
        ImageParamsProvider, SearchSortParamsProvider {
    public enum EStartSearchReasonType {
        // Самый первый поиск при маунте страницы. Заход в новой вкладке, перезагрузка страницы или браузерный назад-вперед(в рамках других страниц).
        mount,
        // Изменились query параметры, в том числе гео. Форма поиска или браузерный назад-вперед(в рамках страницы поиска).
        queryByLocation,
        // Изменились query параметры, но гео осталось прежним
        queryWithSameGeo,
        // Изменился bounds карты.
        mapBounds,
        // Нажатие кнопок назад-вперед под списком.
        navigationToken,
        // Применение фильтров.
        filters,
        // Использование поискового текстового фильтра.
        filtersTypeSearchText,
        // Изменение сортировки.
        sort
    }

    // OfferSearchParamsProvider
    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    private Integer adults = 2;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;

    // DebugOfferSearchParamsProvider
    @ParamName("debug_portal_host")
    @ApiParam(name = "debug_portal_host")
    private String debugPortalHost;

    @ParamName("debug_use_prod_offers")
    @ApiParam(name = "debug_use_prod_offers")
    private boolean debugUseProdOffers = false;

    // SearchFilterParamsProvider
    @ParamName("filter_atoms")
    @ApiParam(name = "filter_atoms", value = "Атомы фильтрации")
    private List<String> filterAtoms;

    @ParamName("filter_price_from")
    @ApiParam(name = "filter_price_from", value = "Цена от")
    @Min(0)
    private Integer filterPriceFrom;

    @ParamName("filter_price_to")
    @ApiParam(name = "filter_price_to", value = "Цена до")
    @Min(0)
    private Integer filterPriceTo;

    @ParamName("only_current_geo_id")
    @ApiParam(name = "only_current_geo_id", value = "Фильтрация отелей по заданному GeoId")
    private boolean onlyCurrentGeoId = true;

    // SearchSortParamsProvider
    @ParamName("selected_sort_id")
    @ApiParam(name = "selected_sort_id", value = "Id выбранного типа сортировки")
    private String selectedSortId;

    @ParamName("sort_origin")
    @ApiParam(name = "sort_origin", value = "Центр сортировки")
    private Coordinates sortOrigin;

    // ImageParamsProvider
    @ParamName("image_limit")
    @ApiParam(name = "image_limit", value = "Image Limit")
    private Integer imageLimit = null;

    @ParamName("image_offset")
    @ApiParam(name = "image_offset", value = "Image Offset")
    private int imageOffset = 0;

    @ParamName("image_sizes")
    @ApiParam(name = "image_sizes", value = "Image sizes")
    private Set<String> imageSizes = null;

    @ParamName("only_top_images")
    @ApiParam(name = "only_top_images", value = "Include only top images")
    @NotNull
    private boolean onlyTopImages = true;// not included in spec

    // Own fields
    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("context")
    @ApiParam(name = "context", value = "Контекст поиска")
    private String context;

    @ParamName("navigation_token")
    @ApiParam(name = "navigation_token", value = "Навигационный контекст для смены отображаемой страницы _в списке_")
    private String navigationToken;

    @ParamName("geo_id")
    @ApiParam(name = "geo_id", value = "Регион поиска, заданный пользователем (при первичном запросе)")
    private Integer geoId;

    @ParamName("geo_location_status")
    @ApiParam(name = "geo_location_status", value = "Доступна ли геолокация")
    private GeoLocationStatus geoLocationStatus;

    @ParamName("user_coordinates")
    @ApiParam(name = "user_coordinates", value = "Координаты пользователя (передаются всегда, когда geoLocationStatus==AVAILABLE)")
    private Coordinates userCoordinates;

    @ParamName("bbox")
    @ApiParam(name = "bbox", value = "Окно карты (при последующих запросах)")
    private BoundingBox bbox;// bbox=37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat

    @ParamName("page_hotel_count")
    @ApiParam(name = "page_hotel_count", value = "Сколько отелей отображать в списке")
    @NotNull
    private int pageHotelCount = 10; // Нужно для корректного формирования навигационных токенов.

    @ParamName("priced_hotel_limit")
    @ApiParam(name = "priced_hotel_limit", value = "Сколько отелей желательно получить с ценами")
    @NotNull
    private int pricedHotelLimit = 20;

    @ParamName("total_hotel_limit")
    @ApiParam(name = "total_hotel_limit", value = "Сколько отелей нужно всего")
    @NotNull
    @Min(Constraints.TOTAL_HOTEL_LIMIT_MIN)
    @Max(Constraints.TOTAL_HOTEL_LIMIT_MAX)
    private int totalHotelLimit = 50;

    @ParamName("poll_epoch")
    @ApiParam(name = "poll_epoch", value = "Номер сессии поллинга фронта (для отладки и аналитики)")
    @NotNull
    private int pollEpoch = 0;

    @ParamName("poll_iteration")
    @ApiParam(name = "poll_iteration", value = "Номер итерации поллинга фронта (для отладки и аналитики)")
    @NotNull
    private int pollIteration = 0;

    @ParamName("start_search_reason")
    @ApiParam(name = "start_search_reason", value = "Причина, по которой фронт запустил процесса поллинга", required = true)
    @NotNull
    private EStartSearchReasonType startSearchReason = null;

    @ParamName("disable_geocounter")
    @ApiParam(name = "disable_geocounter", value = "Не ходить в geocounter за счетчиками")
    @NotNull
    private Boolean disableGeocounter = false;

    @ParamName("top_hotel_slug")
    @ApiParam(name = "top_hotel_slug", value = "Показать первым в списке отель с этим слагом")
    private String topHotelSlug;

    @ParamName("geosearch_params")
    @ApiParam(name = "geosearch_params", value = "Дополнительные параметры геопоиска в виде json. Для отладки, не используется фронтом")
    private String geosearchParams = null;

    @ParamName("force_filters_layout")
    @ApiParam(name = "force_filters_layout", value = "Конфигурация фильтров, котрую нужно использовать вместо варианта по умолчанию. Только для дебага")
    private String forceFiltersLayout = null;

    @ParamName("force_crypta_segment")
    @ApiParam(name = "force_crypta_segment", value = "Сегмент крипты, который нужно использовать вместо реального. В формате keyword_id~segment_id|keyword_id~segment_id|keyword_id~segment_id. Например 174~0|543~0|614~2")
    private String forceCryptaSegment = null;
}
