package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.Region;
import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.api.models.hotels.HotelWithOffers;
import ru.yandex.travel.api.models.hotels.OfferSearchParams;
import ru.yandex.travel.api.models.hotels.OfferSearchProgress;
import ru.yandex.travel.api.models.hotels.OperatorInfo;
import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.api.models.hotels.SearchFilterAndTextParams;

@Data
@NoArgsConstructor
@ApiModel(value = "Поиск отелей - ответ")
public class SearchHotelsRspV1 {
    // Есть ли среди всех отелей выдачи отели с бой офферами или нет в рамках одного поиска
    // Значение проставляется по окончанию все полингов
    private Boolean hasBoyOffers;
    // Поисковый id
    // необходимо передавать через url на страницу отеля с карточек поиска
    private String searchPagePollingId;
    // Поисковый контекст.
    // Необходимо запомнить на фронте и использовать при следующем поисковом запросе.
    private String context;
    // Номера сессии и итерации поллинга.
    // Передаются из запроса без изменений.
    private Integer pollEpoch;
    private Integer pollIteration;
    // Навигационные токены.
    private NavigationTokens navigationTokens;
    // Ограничивающий прямоугольник для карты.
    // - Если пришел в запросе, то отдаем такой же; иначе вычисляем сами и отдаем фронту.
    private BoundingBox bboxAsString;
    // - Он же, но в виде списка.
    private List<Coordinates> bboxAsStruct; //  [0] = leftDown, [1] = upRight
    // Информация о фактически определенном регионе для шапки. "Екатеринбург"
    // @deprecated Должно быть выпилено после перехода на actualRegion
    @Deprecated
    private Region region;
    /* Информация о фактически определенном регионе для шапки.
     * Не содержит лингвистики, т.к может быть составным ("Москва, Бирюлёво" или даже "Тайланд и Вьетнам")
     * Не содержит geoId по тем же причинам
     */
    private ShortRegion actualRegion;
    // Информация об изначальном регионе поиска, соответствует geoId из запроса
    private Region searchRegion;
    // Количество отелей для тескта в фильтрах "Искать цены в X отелях"
    private int foundHotelCount;
    private SearchControlInfo searchControlInfo;
    private FilterInfo filterInfo;
    private SortInfo sortInfo;
    private OfferSearchParams offerSearchParams;
    private OfferSearchProgress offerSearchProgress;
    private Integer nextPollingRequestDelayMs;
    // Длина стабильного префикса списка отелей с ценами.
    private int pricedHotelCount;
    // Ранжированные отели.
    // Первые `pricedHotelCount` отелей можно использовать для отрисовки списка.
    private List<HotelWithOffers> hotels;
    private Map<String, OperatorInfo> operatorById;

    // Если указано - нужно показать баннер соответствующего типа над поисковой выдачей
    private ESearchBannerType searchBannerType;

    private ExtraVisitAndUserParams extraVisitAndUserParams;

    // Время обработки запроса с точки зрения бекенда
    private TimingInfo timingInfo;

    private String topHotelSlug;

    public enum ESearchBannerType {
        NONE,
        MIR,
        MIR_ENABLED,
    }

    public enum BasicFilterGroupType {
        SINGLE,
        MULTI
    }

    @Data
    @NoArgsConstructor
    public static class NavigationTokens {
        // Токен, который необходимо передать бекенду для перехода на следующую страницу.
        private String nextPage;
        // Токен, который необходимо передать бекенду для перехода на предыдущую страницу.
        private String prevPage;
        // Токен, который необходимо передать бекенду для текущей страницы (сохраняется в url фронтом)
        private String currentPage;
    }

    @Data
    @NoArgsConstructor
    public static class BasicFilter {
        // Уникальный идентификатор, нужен для оптимизации верстки
        private String id;

        // Название.
        private String name;
        // Эффект, как отображать этот фильтр.
        // Примеры: подкраска рейтинга, спец-значок для "только спецпредложения".
        // Примеры: для быстрого фильтра -- какой-нибудь спец-цвет или другая штука.
        private String effect;

        // Если enabled == true, то можно на контрол нажимать.
        // Если enabled == false, то нажимать нельзя (будет пустая выдача).
        private boolean enabled;

        // hint -- число отелей, которое будет у пользователя при выборе фильтра.
        // NB: Это информативное для фронта поле.
        // Если фильтр будет расширять ответ, то строка отформатирована как "+100".
        // Если фильтр будет сужать ответ, то строка отформатирована как "50".
        private String hint;

        private List<String> atoms;
    }

    @Data
    @NoArgsConstructor
    public static class BasicFilterGroup {
        // Уникальный идентификатор, нужен для оптимизации верстки
        private String id;

        // Название.
        private String name;
        // Single -- Radio-селект; можно выбрать только одну позицию.
        // Multi -- Multi-Checkbox-селект; можно выбрать много позиций.
        private BasicFilterGroupType type;

        // Что стоит проверять на бекенде:
        // \forall i1, i2 \in Items: i1.Atoms \cap i2.Atoms == \emptyset
        // (любые две позиции обладают непересекающимся набором атомов)
        private List<BasicFilter> items;
    }

    @Data
    @NoArgsConstructor
    public static class SearchControlInfo {
        // Быстрые контролы настройки параметров поиска
        private List<QuickControl> quickControls;
    }

    public interface QuickControl {
        // Уникальный идентификатор, нужен для оптимизации верстки
        String getId();

        // Тип контрола
        String getType();

        // Эффект, как отображать этот фильтр.
        // Примеры: подкраска рейтинга, спец-значок для "только спецпредложения".
        // Примеры: для быстрого фильтра -- какой-нибудь спец-цвет или другая штука.
        String getEffect();

        // Если enabled == true, то можно на контрол нажимать.
        // Если enabled == false, то нажимать нельзя (будет пустая выдача).
        boolean isEnabled();
    }

    @Data
    @NoArgsConstructor
    public static class QuickFilter implements QuickControl {
        private String id;
        private String effect;
        private boolean enabled;
        final private String type = "quick-filter";

        // Название.
        private String name;

        // Подсказка
        private String hint;

        // Для определения факта нажатости быстрофильтра:
        // если в текущем стейте фильтра все атомы из atomsOn есть, и нет ни одного из atomsOff - то быстрофильтр нажат
        // При нажатии на быстрофильтр: все атомы из atomsOff - удаляем из стейта, Все атомы из atomsOn - добавляем в
        // стейт.
        // При отжатии быстрофильтра: Все атомы из atomsOn удаляем из стейта. atomsOff в стейте быть не могло, иначе
        // фильтр бы не был нажат
        private List<String> atomsOn;
        private List<String> atomsOff;
    }

    @Data
    @NoArgsConstructor
    public static class QuickPriceFilter implements QuickControl {
        private String id;
        private String effect;
        private boolean enabled;
        final private String type = "quick-price-filter";

        // Название
        private String name;
    }

    @Data
    @NoArgsConstructor
    public static class QuickSort implements QuickControl {
        private String id;
        private String effect;
        private boolean enabled;
        final private String type = "quick-sort";
    }

    @Data
    @NoArgsConstructor
    public static class PriceFilter {
        // Величина, которую стоит показать пользователю, если он НЕ взаимодействовал с левой границей фильтра
        // (то есть filterPriceFrom не указан).
        // Сейчас рисуется как "3 000 Р", но есть вопросы к дизайну.
        // Также можно использовать для оценки диапазона фильтра по цене.
        private Integer minPriceEstimate;
        // Величина, которую стоит показать пользователю, если он НЕ взаимодействовал с правой границей фильтра
        // (то есть filterPriceTo не указан).
        // Сейчас рисуется как "40 000+ Р".
        // Также можно использовать для оценки диапазона фильтра по цене.
        private Integer maxPriceEstimate;

        // Валюта (для конструирования IPrice-ов).
        private Price.Currency currency;

        // [x_0, x_1, x_2, ..., x_{N-1}], то есть N значений.
        //
        // Предположительно, x_0 == 0 всегда.
        //
        // Bounds описывает набор границ ценовых корзин, где расчитана величина гистограммы.
        // Если гистограмму рисовать не надо, то Bounds отсутствует.
        private List<Integer> histogramBounds;
        // [c_0, c_1, ..., c_{N-1}], то есть N значения.
        //
        // c_0 -- количество отелей с ценой от x_0 до x_1
        // c_i -- количество отелей с ценой от x_i до x_{i+1}
        // c_{N-1} -- количество отелей с ценой от x_{N-1} до +infty
        //
        // Counts может отсутствовать -- тогда столбики рисовать не надо!
        private List<Integer> histogramCounts;
    }

    public enum DetailedFiltersBatchItemType {
        PRICE,
        GROUP
    }

    @Data
    @NoArgsConstructor
    public static class DetailedFiltersItem {
        // Что должно быть в этом элементе
        // PRICE - фильтр по цене, надо взять его из FilterInfo
        // GROUP - обычная группа фильтров (передаётся в detailedFilters)
        private DetailedFiltersBatchItemType type;

        // Заполняется, если type == 'GROUP'
        private BasicFilterGroup detailedFilters;
    }

    @Data
    @NoArgsConstructor
    public static class DetailedFiltersBatch {
        private List<DetailedFiltersItem> items;
    }

    @Data
    @NoArgsConstructor
    public static class ResetFilterInfo {

        @AllArgsConstructor
        public enum EResetFilterReason {
            ZOOMING_MAP("zooming_map"),
            FILTERS("filters"),
            ;
            @JsonValue
            private final String value;

            public String toString() {
                return value;
            };
        }

        @Data
        @NoArgsConstructor
        public static class ResetFilterAction {

            private String name;
            private String effect;

            private List<String> atomsOff;

            private boolean needResetFilterPrice;
            private boolean needResetGeoIdFilter;
        }

        private List<ResetFilterAction> actions;

        private EResetFilterReason resetFilterReason;
    }

    @Data
    @NoArgsConstructor
    public static class GeoIdFilter {
        // Включен ли фильтр или нет
        private boolean selected;
        private String name;
    }

    @Data
    @NoArgsConstructor
    public static class FilterInfo {
        private SearchFilterAndTextParams params;

        // Быстрые фильтры
        private List<QuickFilter> quickFilters;
        // Фильтры одним списком - для экспа с фильтрами слева
        private List<DetailedFiltersItem> detailedFilters;
        // Фильтры под выпадушкой - новые, разбитые на группы для отрисовки по колонкам на десктопе
        private List<DetailedFiltersBatch> detailedFiltersBatches;

        // Ценовой фильтр.
        private PriceFilter priceFilter;
        // Фильтр по региону из поиска
        private GeoIdFilter geoIdFilter;
        // Сброс фильтров при пустой выдаче
        private ResetFilterInfo resetFilterInfo;
    }

    @Data
    @NoArgsConstructor
    public static class ShortRegion {
        private String name;
    }

    public enum SortTypeHint {
        NONE,
        ASCENDING,
        DESCENDING,
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SortType {
        // Идентификатор типа сортировки
        private String id;

        // Название типа сортировки, которое увидит пользователь, если интерфейс НЕ поддерживает сгруппированное отображение сортировок (мобильная версия)
        private String name;

        // Информация о том, какого рода этот тип сортировки: по возрастанию, по убыванию и т.д.
        // В логике не участвует и используется только для отображения пользователю вспомогательной информации (например значка рядом с группой сортировки).
        // Пример:
        // "По цене" - NONE
        // "По цене ⬀" - ASCENDING
        // "По цене ⬂" - DESCENDING
        private SortTypeHint hint;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SortTypeGroup {
        // Идентификатор группы сортировки
        private String id;

        // Название группы сортировки, которое увидит пользователь, если интерфейс поддерживает сгруппированное отображение сортировок (десктопная версия)
        private String name;

        // Требует передачи координат пользователя. То есть перед включением этой сортировки придётся запросить у пользователя доступ к геолокации
        private boolean requiresGeoLocation;

        // Типы сортировки, которые относятся к этой группе. Список не пуст.
        // Порядок элементов важен: при выборе данной группы, активируется сортировка sortTypes[0], переключаются типы по порядку циклически.
        private List<SortType> sortTypes;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SortInfo {
        // Id выбранного типа сортировки
        private String selectedSortId;

        // Центр сортировки (например для сортировки по расстоянию). Нужен не для всех сортировок.
        // lon,lat (например 37.0408809,55.311850)
        private String sortOrigin;

        // Доступные группы сортировки. Обязательно содержит группу, в которой есть тип с id==selectedSortId, если selectedSortId != null
        // Список может быть пуст, тогда блок с сортировками отображать не нужно.
        private List<SortTypeGroup> availableSortTypeGroups;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TimingInfo {
        // Время обработки текущего запроса бекендом (в миллисекундах)
        private Long currentRequestDurationMs;
    }
}
