package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.UserReactionType;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.api.models.hotels.interfaces.HotelTestableUgcProvider;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@NoArgsConstructor
@ApiModel(value = "Реакция на отзыв")
public class SetHotelReviewReactionReqV1 implements HotelIdentifierProvider, HotelTestableUgcProvider {
    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;

    // HotelTestableUgcProvider
    @ParamName("enabled_test_ugc")
    @ApiParam(name = "enabled_test_ugc", value = "Enable testing for UGC")
    public boolean enabledTestUgc = false;

    // Own fields
    @NotNull
    @ParamName("review_id")
    @ApiParam(name = "review_id", value = "Review id", required = true)
    private String reviewId;

    @NotNull
    @ParamName("user_reaction")
    @ApiParam(name = "user_reaction", value = "Review reaction type", required = true)
    private UserReactionType userReaction;
}
