package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.Constraints;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.api.models.hotels.GeoLocationStatus;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.api.models.hotels.interfaces.RegionIdentifierProvider;
import ru.yandex.travel.hotels.common.LanguageType;
import ru.yandex.travel.hotels.common.Permalink;


@ApiModel(value = "Запрос поисковой подсказки")
@Data
@Valid
public class SuggestReqV1 implements HotelIdentifierProvider, RegionIdentifierProvider {

    @ParamName("query")
    @ApiParam(name = "", value = "Запрос пользователя")
    @Size(max = Constraints.SUGGEST_QUERY_SIZE_MAX)
    private String query;

    @ParamName("geoId")
    @ApiParam(name = "", value = "Идентификатор региона")
    private Integer geoId;

    @ParamName("regionSlug")
    @ApiParam(name = "", value = "Slug региона")
    private String regionSlug;

    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Идентификатор отеля, если query & geoId пустые")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug, если query & geoId пустые")
    private String hotelSlug;

    @ParamName("limit")
    @ApiParam(name = "", value = "Максимальное количество саджестов")
    @NotNull
    @Max(Constraints.SUGGEST_LIMIT_MAX)
    private int limit = 5;

    @ParamName("language")
    @ApiParam(name = "language", value = "Язык. Возможные значения: ru, en, tr")
    @NotNull
    private LanguageType language = LanguageType.ru;

    @ParamName("domain")
    @ApiParam(name = "domain", value = "Политический домен запроса")
    @NotNull
    private String domain = "ru";

    @ParamName("sessionId")
    @ApiParam(name = "sessionId", value = "Идентификатор сессии для логов")
    private String sessionId;

    @ParamName("requestIndex")
    @ApiParam(name = "requestIndex", value = "Порядковый номер запроса для логов")
    private Integer requestIndex;

    @ParamName("pathname")
    @ApiParam(name = "pathname", value = "Путь страницы, с которой был отправлен запрос: window.location.pathname, например '/hotels/kazan")
    private String pathname;

    @ParamName("geo_location_status")
    @ApiParam(name = "geo_location_status", value = "Доступна ли геолокация")
    private GeoLocationStatus geoLocationStatus;

    @ParamName("user_coordinates")
    @ApiParam(name = "user_coordinates", value = "Координаты пользователя (передаются всегда, когда geoLocationStatus==AVAILABLE)")
    private Coordinates userCoordinates;
}


