package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;


import java.util.List;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NonNull;

import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.OfferSearchParams;
import ru.yandex.travel.hotels.common.Permalink;

@ApiModel(value = "Ответ с поисковыми подсказками")
@Data
@AllArgsConstructor
public class SuggestRspV1 {

    @Data
    @AllArgsConstructor
    public static class SuggestGroup {

        @ApiModelProperty(value = "Имя группы", example = "Отели")
        private String name;

        @ApiModelProperty(value = "Подсказки в группе")
        private List<SuggestItem> items;

    }

    @Data
    public static class SuggestItem {
        @ApiModelProperty(value = "Идентификатор саджеста для логирования")
        @NonNull
        private String id;

        @ApiModelProperty(value = "Имя саджеста")
        @NonNull
        private String name;

        @ApiModelProperty(value = "Описание саджеста")
        private String description;

        @ApiModelProperty(value = "Параметры перехода по саджесту")
        private RedirectParams redirectParams;
    }

    @Data
    public static class RedirectParams {

        @ApiModelProperty(value = "Тип саджеста")
        @NonNull
        private SuggestType type;

        @ApiModelProperty(value = "id региона")
        private Integer geoId;

        @ApiModelProperty(value = "Пермалинк")
        private Permalink permalink;

        @ApiModelProperty(value = "Главный slug отеля")
        private String hotelSlug; // TODO (alexcrush) implement!

        @ApiModelProperty(value = "Id типа сортировки")
        private String selectedSortId;

        @ApiModelProperty(value = "Координаты, относительно которых будет производиться сортировка по расстоянию")
        private String sortOrigin; // lon,lat

        @ApiModelProperty(value = "Bbox, который покажем пользователю")
        private BoundingBox bbox; // lon,lat~lon,lat

        @ApiModelProperty(value = "Параметры поиска")
        private OfferSearchParams offerSearchParams;
    }

    public enum SuggestType {
        REGION,
        HOTEL,
        HOTELS_NEARBY,
        HISTORY,
        CROSS_SALE;

        @JsonValue
        public String lowerName() {
            return this.name().toLowerCase();
        }
    }

    @ApiModelProperty(value = "Группы подсказок")
    private List<SuggestGroup> groups;
}
