package ru.yandex.travel.api.endpoints.personalization;

import javax.validation.Valid;

import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.komod.cross_search.CrossSearchControllerImpl;
import ru.yandex.travel.api.endpoints.komod.cross_search.req_rsp.TransformSearchContextReqV1;
import ru.yandex.travel.api.endpoints.komod.cross_search.req_rsp.TransformSearchContextRspV1;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;

@RestController
@RequestMapping(value = "/api/komod/cross_search")
@RequiredArgsConstructor
public class CrossSearchController {
    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    private final ResponseProcessor responseProcessor;
    private final CrossSearchControllerImpl crossSearchControllerImpl;

    @RequestMapping(value = "/v1/transform_search_context", method = RequestMethod.GET, produces =
            MediaType.APPLICATION_JSON_VALUE)
    public DeferredResult<TransformSearchContextRspV1> transformSearchContext(@BindFromQuery @Valid TransformSearchContextReqV1 req) {
        return responseProcessor.replyWithFuture(
                "CrossSearchTransformSearchContext",
                () -> crossSearchControllerImpl.transformSearchContext(req)
        );
    }
}
