package ru.yandex.travel.api.endpoints.komod.cross_search.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос трансформации пунктов для сохранения контекста поиска между вкладками на портале")
public class TransformSearchContextReqV1 {
    @ParamName("fromPointKey")
    @ApiParam(value = "point key пункта отправления", examples = @Example({@ExampleProperty("c213"), @ExampleProperty("s9600213")}))
    private String fromPointKey;

    @ParamName("fromGeoId")
    @ApiParam(value = "geo id пункта отправления", examples = @Example({@ExampleProperty("213"), @ExampleProperty("54")}))
    private Integer fromGeoId;

    @ParamName("toPointKey")
    @ApiParam(value = "point key пункта прибытия", examples = @Example({@ExampleProperty("c213"), @ExampleProperty("s9600213")}))
    private String toPointKey;

    @ParamName("toGeoId")
    @ApiParam(value = "geo id пункта прибытия", examples = @Example({@ExampleProperty("213"), @ExampleProperty("54")}))
    private Integer toGeoId;

    @ParamName("vertical")
    @NotNull
    @ApiParam(value = "Вертикаль для которой нужно получить контекст поиска", examples = @Example({@ExampleProperty("avia"), @ExampleProperty("trains")}))
    private TravelVertical vertical;
}
