package ru.yandex.travel.api.endpoints.komod.cross_search.req_rsp;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@AllArgsConstructor
@Getter
public enum TravelVertical implements ValueBasedEnum<String> {
    AVIA("avia"), HOTELS("hotels"), TRAINS("trains"), BUSES("buses");

    @Component
    public static class FromStringConverter implements Converter<String, TravelVertical> {
        @Override
        public TravelVertical convert(@NotNull String source) {
            return TravelVertical.fromString(source);
        }
    }

    private final String value;

    private static final EnumIndex<String, TravelVertical> BY_VALUE = EnumIndex.create(TravelVertical.class);

    @JsonCreator
    public static TravelVertical fromString(String value) {
        return BY_VALUE.getByValue(value);
    }
}
