package ru.yandex.travel.api.endpoints.portal_recipes;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.portal_recipes.req_rsp.PortalRecipesReqV1;
import ru.yandex.travel.api.endpoints.portal_recipes.req_rsp.PortalRecipesRspV1;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;

@RestController
@RequestMapping(value = "/api/common")
@RequiredArgsConstructor
@Slf4j
public class PortalRecipesController {
    private final ResponseProcessor responseProcessor;
    private final PortalRecipesImpl portalRecipesImpl;

    @RequestMapping(value = "/v1/crosslinks", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<PortalRecipesRspV1> getPortalRecipes(@Validated @BindFromQuery PortalRecipesReqV1 request) {
        var deferredResult = new DeferredResult<PortalRecipesRspV1>();
        deferredResult.setResult(portalRecipesImpl.get(request));
        return deferredResult;
    }
}
