package ru.yandex.travel.api.endpoints.portal_recipes;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "portal-recipes-impl", ignoreUnknownFields = false)
@Validated
@Data
@EqualsAndHashCode()
public class PortalRecipesImplProperties {
    private int recipesCount = 5;
    private int crossLinksCount = 15;
    @NotEmpty
    private String aviaCrossLinksTitle;
    @NotEmpty
    private String busesCrossLinksTitle;
    @NotEmpty
    private String hotelsRuCrossLinksTitle;
    @NotEmpty
    private String hotelsForeignCrossLinksTitle;
    @NotEmpty
    private String trainsCrossLinksTitle;
}
