package ru.yandex.travel.api.endpoints.portal_recipes.req_rsp;

import java.util.List;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.models.common.Price;

@Data
@ApiModel(value = "Рецепты - ответ")
public class PortalRecipesRspV1 {

    private RecipesBlock recipes;
    private List<CrossLinksBlock> crossLinks;

    @Data
    public static class DirectionDestination {
        private String slug;
        private Linguistics linguistics;
    }

    @Data
    public static class Direction {
        private DirectionDestination from; // null for hotels
        private DirectionDestination to;
        private Price minPrice;
        private String imageUrl;
    }

    @Data
    public static class RecipesBlock {
        private List<PortalRecipesRspV1.Direction> directions;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class CrossLinksBlock extends RecipesBlock {
        private String title;
    }
}
