package ru.yandex.travel.api.endpoints.pretrip.hotelsblock;

import io.grpc.StatusRuntimeException;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.exceptions.GrpcError;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.api.services.orders.happy_page.PretripEmailService;
import ru.yandex.travel.api.services.orders.happy_page.model.HotelPayload;
import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.credentials.UserCredentials;

@RestController
@RequestMapping(value = "/api/pretrip")
@RequiredArgsConstructor
public class HotelsBlockController {
    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @ExceptionHandler(StatusRuntimeException.class)
    public ResponseEntity<GrpcError> handleGrpcErrors(StatusRuntimeException ex) {
        GrpcError error = GrpcError.fromGrpcStatusRuntimeException(ex);
        return ResponseEntity.status(error.getStatus()).contentType(MediaType.APPLICATION_JSON).body(error);
    }

    private final ResponseProcessor responseProcessor;
    private final PretripEmailService pretripEmailService;

    @RequestMapping(value = "/v1/get_hotels_block", method = RequestMethod.GET, produces = "application/json")
    public DeferredResult<HotelPayload> getHotelsBlock(
            @RequestParam(value = "orderId") String orderId,
            @RequestParam(value = "geoId") Integer geoId,
            @RequestParam(value = "limit", defaultValue = "10", required = false) Integer limit) {
        return responseProcessor.replyWithFuture(
                "HotelsBlock",
                () -> pretripEmailService.getHotelsBlock(orderId, geoId, limit, CommonHttpHeaders.get(), UserCredentials.get()));
    }
}
