package ru.yandex.travel.api.endpoints.serp;

import java.util.List;

import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.misc.io.http.HttpException;
import ru.yandex.travel.api.endpoints.serp.req_rsp.GetPopularDestinationsReqV1;
import ru.yandex.travel.api.endpoints.serp.req_rsp.GetPopularDestinationsRspV1;
import ru.yandex.travel.api.exceptions.InputError;
import ru.yandex.travel.api.exceptions.InvalidInputException;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.hotels.common.HotelNotFoundException;

@RestController
@RequestMapping("/api/serp")
@Api(value = "Serp", description = "Serp Controller")
@RequiredArgsConstructor
public class SerpController {
    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    private final ResponseProcessor responseProcessor;
    private final SerpImpl impl;

    @ExceptionHandler(InvalidInputException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public List<InputError> handleInputErrors(InvalidInputException ex) {
        return ex.getErrors();
    }

    @ExceptionHandler(HotelNotFoundException.class)
    @ResponseStatus(HttpStatus.NOT_FOUND)
    public ResponseEntity<String> handleHotelNotFoundException(HotelNotFoundException e) {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @ExceptionHandler(HttpException.class)
    @ResponseStatus(HttpStatus.BAD_GATEWAY)
    public ResponseEntity<String> handleHttpException(HttpException e) {
        return ResponseEntity.status(HttpStatus.BAD_GATEWAY).contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @RequestMapping(value = "/v1/get_popular_destinations", method = RequestMethod.GET)
    public GetPopularDestinationsRspV1 getPopularDestinationsV1(@Validated @BindFromQuery GetPopularDestinationsReqV1 req) {
        // Future is not used here to save some CPU time
        return impl.getPopularDestinations(req);
    }
}
