package ru.yandex.travel.api.endpoints.serp;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.endpoints.serp.req_rsp.GetPopularDestinationsReqV1;
import ru.yandex.travel.api.endpoints.serp.req_rsp.GetPopularDestinationsRspV1;
import ru.yandex.travel.api.services.hotels.serp_popular_destinations.SerpPopularDestinationsService;

@Component
@RequiredArgsConstructor
@Slf4j
public class SerpImpl {
    private final SerpPopularDestinationsService destinationService;

    public GetPopularDestinationsRspV1 getPopularDestinations(GetPopularDestinationsReqV1 req) {
        GetPopularDestinationsRspV1 result = new GetPopularDestinationsRspV1();
        result.setTitle(destinationService.getTitle());
        result.setDestinations(destinationService.getPopularDestinations(req.getGeoId(), req.getDomain()));
        return result;
    }
}
