package ru.yandex.travel.api.endpoints.subscriptions.req_rsp;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.models.avia.Passengers;
import ru.yandex.travel.api.models.avia.ServiceClass;
import ru.yandex.travel.api.models.common.TravelVertical;
import ru.yandex.travel.api.services.subscriptions.model.better_price_subscription.Tariff;
import ru.yandex.travel.api.services.subscriptions.model.better_price_subscription.Variant;

@Data
@Builder(toBuilder = true)
@JsonDeserialize(builder = SubscribeOnBetterPriceReqV1.SubscribeOnBetterPriceReqV1Builder.class)
@Validated
public class SubscribeOnBetterPriceReqV1 {
    @NotEmpty
    @Email
    private String email;
    @NotNull
    private String source;
    @NotNull
    private TravelVertical travelVerticalName;
    private String timezone;
    private String language;
    private String nationalVersion;

    @NotNull
    private Variant variant;
    @NotNull
    private String fromPointKey;
    @NotNull
    private String toPointKey;
    @NotNull
    private String dateForward;
    private String dateBackward;
    @NotNull
    private Passengers passengers;
    @NotNull
    private ServiceClass serviceClass;
    @NotNull
    private Boolean WithBaggage;
    private Tariff TariffWithoutBaggage;
    private Tariff TariffWithBaggage;

    @JsonPOJOBuilder(withPrefix = "")
    public static class SubscribeOnBetterPriceReqV1Builder {
    }
}
