package ru.yandex.travel.api.endpoints.subscriptions.req_rsp;

import java.util.List;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.models.common.TravelVertical;

@Data
@Builder(toBuilder = true)
@JsonDeserialize(builder = SubscribeReqV1.SubscribeReqV1Builder.class)
@Validated
public class SubscribeReqV1 {
    @NotEmpty
    @Email
    private String email;
    @Deprecated
    private List<CredentialsTuple> credentials;
    private String passportId;
    private String yandexUid;
    @NotNull
    private String source;
    @NotNull
    private TravelVertical travelVerticalName;
    private String timezone;
    private String language;
    private String nationalVersion;

    @JsonPOJOBuilder(withPrefix = "")
    public static class SubscribeReqV1Builder {
    }
}
