package ru.yandex.travel.api.endpoints.subscriptions.req_rsp;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;

@Data
public class SubscriptionPromoConfigReqV1 {
    private String email;
    @NotNull
    private ESubscriptionAuthType authType;
    @NotNull
    @NotBlank
    private String authValue;
    @NotNull
    private ESubscriptionVerticalName vertical;


    @Getter
    public enum ESubscriptionAuthType {
        session,
        iCookie,
        passportId, // = req.blackbox.uid
        yandexUid; // = req.cookies.yandexuid
    }


    @Getter
    public enum ESubscriptionVerticalName {
        trains,
        avia,
        hotels,
        rasp,
        bus,
        promoLanding; // промо страницы
    }

}
