package ru.yandex.travel.api.endpoints.subscriptions.req_rsp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.Value;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.notifier.subscriptions.v1.GetPromoConfigRsp;
import ru.yandex.travel.notifier.subscriptions.v1.PromoCodeForSubscription;

@Value
@Builder
public class SubscriptionPromoConfigRspV1 {
    IPromoCodeForSubscription promoCode;

    public static SubscriptionPromoConfigRspV1 fromProto(GetPromoConfigRsp rsp) {
        var builder = SubscriptionPromoConfigRspV1.builder();
        if (!rsp.hasPromoCode()) {
            return builder.build();
        }
        return builder.promoCode(
                IPromoCodeForSubscription.fromProto(rsp.getPromoCode())
        ).build();
    }

    @Value
    @Builder
    public static class IPromoCodeForSubscription {
        @NonNull
        EPromoCodeType type;
        double amount;
        @JsonInclude(JsonInclude.Include.NON_NULL)
        Number minTotalCost;

        public static IPromoCodeForSubscription fromProto(PromoCodeForSubscription promoCode) {
            var builder = IPromoCodeForSubscription.builder();
            builder.type(EPromoCodeType.fromString(promoCode.getType().name()))
                    .amount(promoCode.getAmount());
            if (promoCode.getMinTotalCost() > 0) {
                builder.minTotalCost(promoCode.getMinTotalCost());
            }
            return builder.build();
        }

        @Getter
        @AllArgsConstructor
        public enum EPromoCodeType implements ValueBasedEnum<String> {
            FIX("fix"),
            PERCENT("percent");

            @JsonValue
            private final String value;
            private static final EnumIndex<String, EPromoCodeType> BY_VALUE = EnumIndex.create(EPromoCodeType.class);

            public static EPromoCodeType fromString(String value) {
                return BY_VALUE.getByValue(value);
            }
        }
    }
}
