package ru.yandex.travel.api.endpoints.takeout.req_rsp;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Builder;
import lombok.RequiredArgsConstructor;
import lombok.Value;

import ru.yandex.travel.api.models.takeout.TakeoutStatus;

@Value
@Builder
public class TakeoutStatusRspV1 {
    TakeoutStatus status;
    List<TakeoutData> data;
    List<TakeoutError> errors;

    @Value
    @Builder
    public static class TakeoutData {
        String id;
        String slug;
        TakeoutDataState state;
        @JsonProperty("update_date")
        String updateDate;
    }

    @RequiredArgsConstructor
    public enum TakeoutDataState {
        READY("ready_to_delete"),
        IN_PROGRESS("delete_in_progress"),
        EMPTY("empty");

        final String value;

        @JsonValue
        public String getValue() {
            return value;
        }
    }

    @Value
    public static class TakeoutError {
        String code;
        String message;
    }
}
