package ru.yandex.travel.api.endpoints.tours_whitelabel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.tours_whitelabel.req_rsp.BindTourReqV1;
import ru.yandex.travel.api.endpoints.tours_whitelabel.req_rsp.BindTourRspV1;
import ru.yandex.travel.api.endpoints.tours_whitelabel.req_rsp.GetWidgetInfoReqV1;
import ru.yandex.travel.api.endpoints.tours_whitelabel.req_rsp.GetWidgetInfoRspV1;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.commons.http.CommonHttpHeaders;

@RestController
@RequestMapping("/api/tours_whitelabel")
@Api(value = "ToursWhitelabel")
@RequiredArgsConstructor
public class ToursWhitelabelController {

    private final ResponseProcessor responseProcessor;
    private final ToursWhitelabelImpl impl;

    @RequestMapping(value = {"/v1/get_widget_info"}, method = RequestMethod.GET, produces = "application/json")
    @ApiOperation(value = "Данные для виджета")
    public DeferredResult<GetWidgetInfoRspV1> getWidgetInfoV1(@Validated @BindFromQuery GetWidgetInfoReqV1 req) {
        return responseProcessor.replyWithFuture("ToursWhitelabelGetWidgedInfoV1", () ->
                impl.getWidgetInfo(req, CommonHttpHeaders.get()));
    }

    @RequestMapping(value = {"/v1/bind_tour"}, method = RequestMethod.POST, produces = "application/json")
    @ApiOperation(value = "Постпривязка тура")
    public DeferredResult<BindTourRspV1> getWidgetInfoV1(@Validated @BindFromQuery BindTourReqV1 req) {
        return responseProcessor.replyWithFuture("ToursWhitelabelBindTourV1", () ->
                impl.bindTour(req, CommonHttpHeaders.get()));
    }
}
