package ru.yandex.travel.api.endpoints.tours_whitelabel.req_rsp;

import java.time.LocalDate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.endpoints.hotels_portal.req_rsp.RequestAttributionProviderImpl;
import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Запрос постпривязки тура leveltravel")
public class BindTourReqV1 extends RequestAttributionProviderImpl {
    @ParamName("tour_id")
    @ApiParam(name = "tour_id")
    private String tourId;

    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата начала тура")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата окончания тура")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;
}
