package ru.yandex.travel.api.endpoints.trains_booking_flow.req_rsp;

import java.util.List;
import java.util.UUID;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;

import ru.yandex.travel.api.models.subscriptions.PromoSubscriptionRequestParams;
import ru.yandex.travel.api.models.train.CreateOrderPassengerV2;
import ru.yandex.travel.api.models.train.CreateOrderUserInfo;

@Data
public class CreateOrderReqV2 {
    @NotNull
    private UUID offerId;
    @NotEmpty
    private String label;
    @NotEmpty
    @Valid
    private List<CreateOrderPassengerV2> passengers;
    @NotEmpty
    private String deduplicationKey;
    private String customerEmail;
    private String customerPhone;
    @NotNull
    private JsonNode orderHistory;
    private String correlationId;

    @NotNull
    @Valid
    private CreateOrderUserInfo userInfo;

    private PromoSubscriptionRequestParams subscriptionParams;

    private boolean mockPayment;
    private String paymentTestContextToken;

    private String trainTestContextToken;
}
