package ru.yandex.travel.api.endpoints.trains_booking_flow.req_rsp;

import java.time.Instant;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.api.models.train.Passenger;
import ru.yandex.travel.api.models.train.Refund;
import ru.yandex.travel.api.models.train.SegmentInfo;
import ru.yandex.travel.api.models.train.Station;
import ru.yandex.travel.api.models.train.TrainInfo;
import ru.yandex.travel.api.models.train.WarningInfo;

@Data
@EqualsAndHashCode(callSuper = true)
public class OrderInfoRspV1 extends OrderStatusRspV1 {
    // todo(tlg-13,ganintsev): TRAVELBACK-1828: the fields below should be removed (except for 'warnings')
    // legacy fields start
    private Integer partnerOrderId;
    private String reservationNumber;
    private Station stationFrom;
    private Station stationTo;
    private TrainInfo trainInfo;
    private String carType;
    private String compartmentGender;
    private Instant arrival;
    private Instant departure;
    private String partner;
    private String carNumber;
    private String specialNotice;
    private List<WarningInfo> warnings;
    private boolean twoStorey;
    private String coachOwner;
    private String companyTitle;
    private List<Passenger> passengers;
    // legacy fields end

    private List<SegmentInfo> segments;

    private List<Refund> refunds;
    private String paymentReceiptUrl;

    private String customerEmail;
    private String customerPhone;
}

