package ru.yandex.travel.api.endpoints.trains_search.req_rsp;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
public class DirectionReq {
    @NotBlank
    private String fromSlug;

    @NotBlank
    private String toSlug;

    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";
}
