package ru.yandex.travel.api.endpoints.trains_search.req_rsp;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.travel.api.models.crosslinks.CrosslinksHotelsBlock;
import ru.yandex.travel.api.models.seo.SeoInfo;
import ru.yandex.travel.api.models.train.seo.TrainDirectionFAQBlock;
import ru.yandex.travel.api.models.train.seo.TrainDirectionHeaderBlock;
import ru.yandex.travel.api.models.train.seo.TrainDirectionInfoBlock;
import ru.yandex.travel.api.models.train.seo.TrainDirectionSegmentsBlock;
import ru.yandex.travel.api.models.train.seo.TrainDirectionSeoInfo;

@Data
@AllArgsConstructor
public class DirectionRsp {
    @Data
    @AllArgsConstructor
    public static class Blocks {
        private TrainDirectionHeaderBlock header;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private TrainDirectionSegmentsBlock segments;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private TrainDirectionInfoBlock info;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private TrainDirectionFAQBlock faq;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private CrosslinksHotelsBlock hotels;
    }

    private String searchDate;
    private Blocks blocks;
    private SeoInfo<TrainDirectionSeoInfo> seoInfo;
}
