package ru.yandex.travel.api.endpoints.trips.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.komod.trips.api.trips.v1.TripsListItemType;

@RequiredArgsConstructor
@Getter
public enum TripListItemType {
    REAL("REAL", TripsListItemType.REAL_TYPE),
    ORDER("ORDER", TripsListItemType.ORDER_TYPE);

    private final String value;
    private final TripsListItemType proto;

    public static final EnumIndex<TripsListItemType, TripListItemType> BY_PROTO =
            EnumIndex.create(TripListItemType.class, TripListItemType::getProto);
}
