package ru.yandex.travel.api.endpoints.trips.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
@Getter
public enum TripState {
    CANCELLED("CANCELLED", ru.yandex.travel.komod.trips.api.trips.v1.TripState.TRIP_STATE_CANCELLED),
    CONFIRMED("CONFIRMED", ru.yandex.travel.komod.trips.api.trips.v1.TripState.TRIP_STATE_CONFIRMED);

    private final String value;
    private final ru.yandex.travel.komod.trips.api.trips.v1.TripState proto;

    public static final EnumIndex<ru.yandex.travel.komod.trips.api.trips.v1.TripState, TripState> BY_PROTO =
            EnumIndex.create(TripState.class, TripState::getProto);
}
