package ru.yandex.travel.api.endpoints.trips.model.blocks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@Data
public class AsyncTripBlock extends TripBlock {

    @JsonProperty("isLoaded")
    @Getter(AccessLevel.PRIVATE)
    private final boolean isLoaded;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final AsyncInternalBlock block;
}
