package ru.yandex.travel.api.endpoints.trips.model.blocks;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
@Getter
public enum NotificationType {
    AVIA_CHECK_IN("AVIA_CHECK_IN",
            ru.yandex.travel.komod.trips.api.trips.v1.NotificationType.NOTIFICATION_TYPE_AVIA_ONLINE_CHECK_IN),
    HOTEL_DEFERRED_PAYMENT("HOTEL_DEFERRED_PAYMENT",
            ru.yandex.travel.komod.trips.api.trips.v1.NotificationType.NOTIFICATION_TYPE_HOTEL_DEFERRED_PAYMENT);

    private final String value;
    private final ru.yandex.travel.komod.trips.api.trips.v1.NotificationType proto;

    public static final EnumIndex<ru.yandex.travel.komod.trips.api.trips.v1.NotificationType, NotificationType> BY_PROTO =
            EnumIndex.create(NotificationType.class, NotificationType::getProto);
}
