package ru.yandex.travel.api.endpoints.trips.model.blocks;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.SuperBuilder;

import ru.yandex.travel.api.endpoints.avia_country_restrictions.req_rsp.v1.CountryRestrictionsReq;

@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@Data
public class RestrictionsBlock extends TripBlock {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class Request extends CountryRestrictionsReq {};

    @Builder
    @Data
    public static class BlockImpl {
        private String fromCountryTitle;
        private String toCountryTitle;
        private Request request;
    }

    private final BlockImpl block;
}
