package ru.yandex.travel.api.endpoints.trips.model.blocks;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.komod.trips.api.trips.v1.BlockType;

@RequiredArgsConstructor
@Getter
public enum TripBlockType implements ValueBasedEnum<String> {
    HOTEL_ORDER("HOTEL_ORDER", BlockType.HOTELS_ORDER_BLOCK_TYPE),
    AVIA_ORDER("AVIA_ORDER", BlockType.AVIA_ORDER_BLOCK_TYPE),
    TRAIN_ORDER("TRAIN_ORDER", BlockType.TRAIN_ORDER_BLOCK_TYPE),
    HOTEL_CROSS_SALE("HOTEL_CROSS_SALE", BlockType.HOTELS_CROSS_SALE_BLOCK_TYPE),
    ACTIVITIES("ACTIVITIES", BlockType.ACTIVITIES_BLOCK_TYPE),
    RESTRICTIONS("RESTRICTIONS", BlockType.RESTRICTIONS_BLOCK_TYPE),
    BUS_ORDER("BUS_ORDER", BlockType.BUS_ORDER_BLOCK_TYPE),
    NOTIFICATIONS("NOTIFICATIONS", BlockType.NOTIFICATIONS_BLOCK_TYPE),
    FORECAST("FORECAST", BlockType.FORECAST_BLOCK_TYPE);

    private final String value;
    private final BlockType proto;

    public static final EnumIndex<BlockType, TripBlockType> BY_PROTO =
            EnumIndex.create(TripBlockType.class, TripBlockType::getProto);

    public static EnumIndex<String, TripBlockType> BY_VALUE = EnumIndex.create(TripBlockType.class);

}
