package ru.yandex.travel.api.endpoints.trips.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос активных поездок в бургер")
public class GetActiveTripsReqV1 {
    @ParamName("userGeoId")
    @ApiParam(name = "userGeoId", value = "Гео-id региона пользователя")
    @NotNull
    private int userGeoId = 10000;

    @ParamName("pastLimit")
    @ApiParam(name = "limit", value = "Количество активных поездок")
    @NotNull
    private int limit = 2;
}
